/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.data;

import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import net.ftb.data.ModPack;
import net.ftb.gui.LaunchFrame;
import net.ftb.log.Logger;
import net.ftb.util.ErrorUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.winreg.JavaFinder;
import net.ftb.util.winreg.JavaInfo;

public class Settings
extends Properties {
    private static Settings settings;
    private File configFile;
    private static JavaInfo currentJava;
    private boolean forceUpdateEnabled = false;

    public Settings(File file) throws IOException {
        this.configFile = file;
        if (file.exists()) {
            this.load(new FileInputStream(file));
        } else {
            LaunchFrame.noConfig = true;
        }
    }

    public void save() {
        try {
            FileOutputStream fos = new FileOutputStream(this.configFile);
            this.store(fos, "FTBLaunch Config File");
            fos.close();
        }
        catch (IOException e) {
            Logger.logError("Failed to save settings", e);
        }
    }

    public String getRamMax() {
        if (this.getCurrentJava().is64bits && OSUtils.getOSTotalMemory() > 6144L) {
            return this.getProperty("ramMax", Integer.toString(2048));
        }
        if (this.getCurrentJava().is64bits) {
            return this.getProperty("ramMax", Integer.toString(1536));
        }
        return this.getProperty("ramMax", Integer.toString(1024));
    }

    public void setRamMax(String max) {
        this.setProperty("ramMax", max);
    }

    public String getLastUser() {
        return this.getProperty("lastUser", null);
    }

    public void setLastUser(String user) {
        this.setProperty("lastUser", user);
    }

    public String getInstallPath() {
        return this.getProperty("installPath", OSUtils.getDefInstallPath());
    }

    public void setInstallPath(String path) {
        this.setProperty("installPath", path);
    }

    public Boolean getUseSystemProxy() {
        return Boolean.valueOf(this.getProperty("useSystemProxy", "false"));
    }

    public void setUseSystemProxy(Boolean flag) {
        this.setProperty("useSystemProxy", String.valueOf(flag));
    }

    public boolean isBetaChannel() {
        return Boolean.valueOf(this.getProperty("betaChannel", "false"));
    }

    public void setBetaChannel(boolean flag) {
        this.setProperty("betaChannel", String.valueOf(flag));
    }

    public String getJavaPath() {
        String javaPath = this.getProperty("javaPath", null);
        if (javaPath == null || !new File(javaPath).isFile()) {
            this.remove("javaPath");
        }
        if ((javaPath = this.getProperty("javaPath", this.getDefaultJavaPath())) == null || !new File(javaPath).isFile()) {
            ErrorUtils.tossError("Unable to find java; point to java executable file in Advanced Options or game will fail to launch.");
        }
        return javaPath;
    }

    public JavaInfo getCurrentJava() {
        if (currentJava == null) {
            try {
                currentJava = new JavaInfo(this.getJavaPath());
            }
            catch (Exception e) {
                Logger.logError("Error while creating JavaInfo", e);
            }
        }
        return currentJava;
    }

    /*
     * WARNING - void declaration
     */
    public String getDefaultJavaPath() {
        JavaInfo javaVersion;
        String separator = System.getProperty("file.separator");
        if (OSUtils.getCurrentOS() == OSUtils.OS.MACOSX) {
            JavaInfo javaVersion2 = JavaFinder.parseJavaVersion();
            if (javaVersion2 != null && javaVersion2.path != null) {
                return javaVersion2.path;
            }
        } else if (OSUtils.getCurrentOS() == OSUtils.OS.WINDOWS && (javaVersion = JavaFinder.parseJavaVersion()) != null && javaVersion.path != null) {
            void var2_3;
            return var2_3.path.replace(".exe", "w.exe");
        }
        return System.getProperty("java.home") + "/bin/java";
    }

    public void setJavaPath(String path) {
        if (this.getDefaultJavaPath().equals(path) || path.isEmpty()) {
            this.remove("javaPath");
        } else {
            this.setProperty("javaPath", path);
        }
    }

    public String getStyle() {
        return this.getProperty("style", "defaultStyle.cfg");
    }

    public void setStyle(String path) {
        this.setProperty("style", path);
    }

    public void setConfigFile(File path) {
        this.configFile = path;
    }

    public String getLocale() {
        return this.getProperty("locale", "enUS");
    }

    public void setLocale(String locale) {
        this.setProperty("locale", locale);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setLastFTBPack(String name) {
        this.setProperty("lastFTBPack", name);
    }

    public void setLastThirdPartyPack(String name) {
        this.setProperty("lastThirdPartyPack", name);
    }

    public String getLastFTBPack() {
        return this.getProperty("lastFTBPack", ModPack.getPack(0).getDir());
    }

    public String getLastThirdPartyPack() {
        return this.getProperty("lastThirdPartyPack", ModPack.getPack(0).getDir());
    }

    public void setDownloadServer(String server) {
        this.setProperty("downloadServer", server);
    }

    public String getDownloadServer() {
        return this.getProperty("downloadServer", "Automatic");
    }

    public void setConsoleActive(boolean console) {
        this.setProperty("consoleActive", String.valueOf(console));
    }

    public boolean getConsoleActive() {
        return Boolean.valueOf(this.getProperty("consoleActive", "true"));
    }

    public void setOptJavaArgs(boolean console) {
        this.setProperty("optJavaArgs", String.valueOf(console));
    }

    public boolean getOptJavaArgs() {
        return Boolean.valueOf(this.getProperty("optJavaArgs", "false"));
    }

    public void setPackVer(String string) {
        this.setProperty(ModPack.getSelectedPack().getDir(), string);
        if (ModPack.getSelectedPack().getDir().equals("mojang_vanilla")) {
            ModPack.setVanillaPackMCVersion(string.equalsIgnoreCase("Recommended Version") ? ModPack.getSelectedPack().getVersion() : string);
        }
    }

    public String getPackVer() {
        return this.getProperty(ModPack.getSelectedPack().getDir(), "Recommended Version");
    }

    public String getPackVer(String packDir) {
        return this.getProperty(packDir, "Recommended Version");
    }

    public String getLastAddPath() {
        return this.getProperty("lastAddPath", "");
    }

    public void setLastAddPath(String string) {
        this.setProperty("lastAddPath", string);
    }

    public void addPrivatePack(String code) {
        if (code == null || code.isEmpty()) {
            return;
        }
        if (this.getProperty("privatePacks") != null) {
            ArrayList<String> packList = this.getPrivatePacks();
            if (!packList.contains(code)) {
                packList.add(code);
                this.setPrivatePacks(packList);
            }
        } else {
            this.setProperty("privatePacks", code);
        }
    }

    public void removePrivatePack(String code) {
        ArrayList<String> codes = this.getPrivatePacks();
        if (codes.contains(code)) {
            codes.remove(code);
        }
        this.setPrivatePacks(codes);
    }

    public void setPrivatePacks(List<String> codes) {
        String out = "";
        String sep = "";
        for (String s : codes) {
            out = out + sep + s;
            sep = ",";
        }
        this.setProperty("privatePacks", out);
    }

    public ArrayList<String> getPrivatePacks() {
        String[] temp = this.getProperty("privatePacks", "").split(",");
        if (temp.length > 0) {
            ArrayList<String> packs = new ArrayList<String>();
            Collections.addAll(packs, temp);
            return packs;
        }
        return null;
    }

    public void setNewsDate() {
        this.setProperty("newsDate", Long.toString(Calendar.getInstance().getTime().getTime()));
    }

    public String getNewsDate() {
        return this.getProperty("newsDate", Long.toString(new Date(0L).getTime()));
    }

    public void setLastExtendedState(int lastExtendedState) {
        this.setProperty("lastExtendedState", String.valueOf(lastExtendedState));
    }

    public void setGeneratedID(String uuid) {
        this.setProperty("trackinguuid", uuid);
    }

    public String getGeneratedID() {
        return this.getProperty("trackinguuid", "");
    }

    public int getLastExtendedState() {
        return Integer.valueOf(this.getProperty("lastExtendedState", String.valueOf(6)));
    }

    public void setKeepLauncherOpen(boolean state) {
        this.setProperty("keepLauncherOpen", String.valueOf(state));
    }

    public boolean getKeepLauncherOpen() {
        return Boolean.parseBoolean(this.getProperty("keepLauncherOpen", "false"));
    }

    public void setSnooper(boolean state) {
        this.setProperty("snooperDisable", String.valueOf(state));
    }

    public boolean getSnooper() {
        return Boolean.parseBoolean(this.getProperty("snooperDisable", "false"));
    }

    public void setDebugLauncher(boolean state) {
        this.setProperty("debugLauncher", String.valueOf(state));
    }

    public boolean getDebugLauncher() {
        return Boolean.parseBoolean(this.getProperty("debugLauncher", "false"));
    }

    public void setLoaded(boolean state) {
        this.setProperty("loaded", String.valueOf(state));
    }

    public boolean getLoaded() {
        return Boolean.parseBoolean(this.getProperty("loaded", "false"));
    }

    public String getAdditionalJavaOptions() {
        return this.getProperty("additionalJavaOptions", "");
    }

    public void setAdditionalJavaOptions(String opts) {
        this.setProperty("additionalJavaOptions", opts);
    }

    public void setLastPosition(Point lastPosition) {
        int x = lastPosition.x;
        int y = lastPosition.y;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        Point p = new Point(x, y);
        this.setObjectProperty("lastPosition", p);
    }

    public Point getLastPosition() {
        Point lastPosition = (Point)this.getObjectProperty("lastPosition");
        if (lastPosition == null) {
            lastPosition = new Point(300, 300);
        }
        return lastPosition;
    }

    public void setLastDimension(Dimension lastDimension) {
        this.setObjectProperty("lastDimension", lastDimension);
    }

    public Dimension getLastDimension() {
        Dimension lastDimension = (Dimension)this.getObjectProperty("lastDimension");
        if (lastDimension == null) {
            lastDimension = new Dimension(854, 480);
        }
        return lastDimension;
    }

    public void setObjectProperty(String propertyName, Serializable value) {
        this.setProperty(propertyName, Settings.objectToString(value));
    }

    public Object getObjectProperty(String propertyName) {
        return Settings.objectFromString(this.getProperty(propertyName, ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object objectFromString(String s) {
        Object object;
        if (s == null || s.isEmpty()) {
            return null;
        }
        byte[] data = DatatypeConverter.parseBase64Binary((String)s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                ois.close();
                throw throwable;
            }
            catch (Exception e) {
                Logger.logError("Failed to read object from string: " + s, e);
                return null;
            }
        }
        ois.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String objectToString(Serializable o) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(o);
            string = DatatypeConverter.printBase64Binary((byte[])baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                baos.close();
                oos.close();
                throw throwable;
            }
            catch (Exception e) {
                Logger.logError("Failed to write object to string" + o, e);
                return null;
            }
        }
        baos.close();
        oos.close();
        return string;
    }

    public boolean getBoolean(String name) {
        return Boolean.valueOf(this.getProperty(name, "false"));
    }

    public void setBoolean(String name, boolean value) {
        this.setProperty(name, String.valueOf(value));
    }

    public void cleanNamespace(String name) {
        for (String s : this.stringPropertyNames()) {
            if (!s.startsWith(name)) continue;
            this.remove(s);
        }
    }

    public static Settings getSettings() {
        return settings;
    }

    public static void setCurrentJava(JavaInfo currentJava) {
        Settings.currentJava = currentJava;
    }

    public boolean isForceUpdateEnabled() {
        return this.forceUpdateEnabled;
    }

    public void setForceUpdateEnabled(boolean forceUpdateEnabled) {
        this.forceUpdateEnabled = forceUpdateEnabled;
    }

    static {
        currentJava = null;
        try {
            settings = new Settings(new File(OSUtils.getDynamicStorageLocation(), "ftblaunch.cfg"));
        }
        catch (IOException e) {
            Logger.logError("Failed to load settings", e);
        }
    }
}

